﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="System.Globalization" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Lista obecności</title>
		<script runat="server">

            static readonly string wolnyFormat = "<SPAN style='FONT-SIZE: 5pt; WIDTH: 100%; HEIGHT: 100%; FONT-FAMILY: Tahoma; HEIGHT: 14pt; BACKGROUND-COLOR: yellow; TEXT-ALIGN: center'>{0}</SPAN>";
            static readonly string swietoFormat = "<SPAN style='FONT-SIZE: 5pt; WIDTH: 100%; HEIGHT: 100%; FONT-FAMILY: Tahoma; HEIGHT: 14pt; BACKGROUND-COLOR: gold; TEXT-ALIGN: center'>{0}</SPAN>";
            static readonly string normalFormat = "<SPAN style='FONT-SIZE: 5pt; WIDTH: 100%; HEIGHT: 100%; FONT-FAMILY: Tahoma; HEIGHT: 14pt; TEXT-ALIGN: center'>{0}</SPAN>";
            static readonly string nieobecFormat = "<SPAN style='FONT-SIZE: 5pt; WIDTH: 100%; HEIGHT: 100%; FONT-FAMILY: Tahoma; HEIGHT: 14pt; BACKGROUND-COLOR: lightgreen; TEXT-ALIGN: center'>{0}</SPAN>";
            static readonly string zwolnFormat = "<SPAN style='FONT-SIZE: 5pt; WIDTH: 100%; HEIGHT: 100%; FONT-FAMILY: Tahoma; HEIGHT: 14pt; BACKGROUND-COLOR: gainsboro; TEXT-ALIGN: center'>{0}</SPAN>";
		    
            class PracInfo {
                readonly SrParams srpars;
                readonly Periods okresy = Periods.Empty;
                readonly FromTo okres;
                readonly object[] dni;
                readonly Log log;

                public PracInfo(Pracownik pracownik, Wydzial wydzial, FromTo okres, SrParams srpars, Log log) {
                    this.okres = okres;
                    this.srpars = srpars;
                    this.log = log;
                    dni = new object[okres.Days];

                    foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres))
                        if ((ph.Etat.EfektywnyOkres * okres) != FromTo.Empty && (ph.Etat.Wydzial == wydzial || srpars.BezPodzialuNaWydzialy))
                            okresy = okresy + ph.Etat.EfektywnyOkres;

                    try {
                        okresy = okresy.ToFlat() * okres;
                        KalkulatorPracy praca = new KalkulatorPracy(pracownik);
                        praca.LoadOkres(okresy.Outer);

                        if (srpars.PokazNieobecnosci)
                            foreach (FromTo o in okresy) {
                                foreach (OkresNieobecności on in praca.Nieobecnosci(o, true))
                                    foreach (Date d in on.Okres)
                                        if (!srpars.NieobecnosciWgTypuDnia || on.Definicja.TypDni == TypyDni.Kalendarzowe || praca.Plan[d].Definicja.Typ == TypDnia.Pracy)
                                            dni[d - okres.From] = on.Definicja;
                            }

                        foreach (FromTo o in okresy)
                            foreach (Date d in o)
                                if (dni[d - okres.From] == null)
                                    dni[d - okres.From] = praca.Plan[d];
                    }
                    catch {
                        log.WriteLine("Błąd dla " + pracownik + " - próba wykonania raportu dla pracownika rozliczanego wg zestawień czasu pracy w okresie: " + okres);
                    }
                }

                public object this[Date data] {
                    get {
                        if (!okresy.Contains(data))
                            return false;
                        return dni[data - okres.From];
                    }
                }
            }
	
	class LpPage {
        readonly SrParams srpars;
        readonly Log log;
        FromTo okres;
		ArrayList pracownicy = new ArrayList();
		ArrayList info = new ArrayList();
		Wydzial wydzial;
		int nr;
		public LpPage(Wydzial wydzial, FromTo okres, int nr, SrParams srpars, Log log) {
            this.srpars = srpars;
            this.log = log;
            this.wydzial = wydzial;
			this.okres = okres;
			this.nr = nr;
		}
		public LpPage(LpPage page) {
            this.srpars = page.srpars;
            this.log = page.log;
            this.wydzial = page.Wydzial;
			this.okres = page.okres;
			this.nr = page.Nr + 1;
		}
		public Wydzial Wydzial {
			get { return wydzial; }
		}
		public int Nr {
			get { return nr; }
		}
		public ArrayList Pracownicy {
			get { return pracownicy; }
		}
		public Pracownik this [int i] {
			get {
				if (i<pracownicy.Count)
					return (Pracownik)pracownicy[i];
				return null;
			}
		}
		public object this [int i, Date data] {
			get {
				if (i<pracownicy.Count)
					return ((PracInfo)info[i])[data];
				return null;
			}
		}
		public void Add(Pracownik pracownik) {
			pracownicy.Add(pracownik);
			info.Add(new PracInfo(pracownik, wydzial, okres, srpars, log));
		}
	}
	
	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
			Date data;
			if (context.Contains(typeof(ActualDate)))
				data = ((ActualDate)context[typeof(ActualDate)]).Actual;
			else
				data = Date.Today;
				
			miesiac = new YearMonth(data)+1;
		}
		
		YearMonth miesiac;
		[Required]
		[Priority(10)]
		[Caption("Lista obecności za")]
		public YearMonth Miesiac {
			get { return miesiac; }
			set { 
				miesiac = value; 
				OnChanged(EventArgs.Empty);
			}
		}			
		
		bool wszyscy = true;
		[Priority(20)]
		[Caption("Wydruk dla wszystkich")]
		public bool Wszyscy {
			get { return wszyscy; }
			set { 
				wszyscy = value; 
				OnChanged(EventArgs.Empty);
			}
		}		
		
		Wydzial wydzial;
		[Priority(30)]
		[Caption("Wybrany wydział")]
		public Wydzial Wydzial {
			get { return wydzial; }
			set { 
				wydzial = value; 
				OnChanged(EventArgs.Empty);
			}
		}		
	}


    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //Sposób pokazywania nieobecności liczonych w dniach pracy.
        //Pole ustawione na true oznacza, że takie nieobecności są wykazywane
        //tylko w dni pracy.    
        //const bool nieobecnościWgTypuDnia = false;
        bool nieobecnosciWgTypuDnia = false;
        [Priority(10)]
        [Caption("Nieobecn. wg typu dnia")]
        public bool NieobecnosciWgTypuDnia {
            get { return nieobecnosciWgTypuDnia; }
            set {
                nieobecnosciWgTypuDnia = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Pokazuj wprowadzone nieobecności     
        //const bool pokażNieobecności = true;
        bool pokazNieobecnosci = true;
        [Priority(20)]
        [Caption("Pokaż nieobecności")]
        public bool PokazNieobecnosci {
            get { return pokazNieobecnosci; }
            set {
                pokazNieobecnosci = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Wypełnij informacje o czasie pracy na podstawie planu pracy pracownika    
        //const bool pokażPlanPracy = false;
        bool pokazPlanPracy = false;
        [Priority(30)]
        [Caption("Pokaż plan pracy")]
        public bool PokazPlanPracy {
            get { return pokazPlanPracy; }
            set {
                pokazPlanPracy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Zostanie wydrykowana płaska lista pracowników bez podziału na wydziały    
        //const bool bezPodziałuNaWydziały = false;
        bool bezPodzialuNaWydzialy = false;
        [Priority(40)]
        [Caption("Bez podz. na wydziały")]
        public bool BezPodzialuNaWydzialy {
            get { return bezPodzialuNaWydzialy; }
            set {
                bezPodzialuNaWydzialy = value;
                OnChanged(EventArgs.Empty);
            }
        }		
    }		
		                                
	PrnParams pars = null; 
	[Context] 
	public PrnParams Params { 
		set { pars = value; } 
	}

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
		        
	string title;
    FromTo okres;    
	
	KalkulatorKalendarza kalkK;
    Log log = new Log("Wydruk: Lista obecności - podpisy - szczegółowa", true);
	
	void OnContextLoad(Object sender, EventArgs args) {
        ReportHeader1["MIESIĄC"] = pars.Miesiac.ToString();
		title = ReportHeader1.Title;
		//colMonth.Caption = "<h4>" + pars.Miesiac.ToString("MMMM", CultureInfo.CurrentCulture) + "<br/>" + pars.Miesiac.ToString("yyyy", CultureInfo.CurrentCulture) + "</h3>";
		okres = (FromTo)pars.Miesiac;

		kalkK = new KalkulatorKalendarza(KalendModule.GetInstance(dc).Kalendarze.Standard);
		kalkK.LoadOkres(okres);
						
		Hashtable wydzialy = new Hashtable();	
        
        IEnumerable rows;
        if (!pars.Wszyscy)
            rows = (Pracownik[])dc[typeof(Pracownik[])];
        else
            rows = KadryModule.GetInstance(dc).Pracownicy.GetNaEtatach(okres, (Wydzial)null, false, true);
        
        Hashtable pracownicy = null;
		foreach (Pracownik pracownik in rows)
			if (pracownik is PracownikFirmy)
				foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres))
					if ((ph.Etat.EfektywnyOkres*okres)!=FromTo.Empty)
                        if (pars.Wydzial == null || ph.Etat.Wydzial == pars.Wydzial) {
                            if (!srpars.BezPodzialuNaWydzialy || pracownicy == null) {
                                object key = (object)ph.Etat.Wydzial;
                                pracownicy = (Hashtable)wydzialy[key];
                                if (pracownicy == null)
                                    wydzialy.Add(key, pracownicy = new Hashtable());
                            }
                            pracownicy[pracownik] = true;
                        }
				
		ArrayList lw = new ArrayList(wydzialy.Keys);
		lw.Sort();
		
		ArrayList pages = new ArrayList();
		LpPage page;
		foreach (object key in lw) {
            ArrayList pracownicy2 = new ArrayList(((Hashtable)wydzialy[key]).Keys);
			pracownicy2.Sort();
            pages.Add(page = new LpPage(key as Wydzial, okres, 1, srpars, log));
			foreach (Pracownik pracownik in pracownicy2) {
				if (page.Pracownicy.Count==4)
					pages.Add(page=new LpPage(page));
				page.Add(pracownik);			
			}
		}
		
		DataRepeater1.DataSource = pages;
	}
	
	LpPage currentPage;
	
	void DataRepeater1_BeforeRow(Object sender, EventArgs args) {        
		ReportHeader1.Title = title;
		currentPage = (LpPage)DataRepeater1.CurrentRow;
        ReportHeader1["WYDZIAL"] = currentPage.Wydzial == null ? "razem" : currentPage.Wydzial.Nazwa;
        ReportHeader1["NR"] = currentPage.Nr.ToString();

        string header = string.Format(RemoveLF(tableHeaderFormat),
            PracTitle(currentPage[0]),
            PracTitle(currentPage[1]),
            PracTitle(currentPage[2]),
            PracTitle(currentPage[3]));
        string body = "";
        foreach (Date date in okres) {

            string stdformat;
            switch (kalkK[date].Definicja.Typ) {
                case TypDnia.Pracy:
                    stdformat = normalFormat; break;
                case TypDnia.Wolny:
                    stdformat = wolnyFormat; break;
                case TypDnia.Świąteczny:
                    stdformat = swietoFormat; break;
                default:
                    stdformat = "{0}"; break;
            }
            
            string a0, b0, c0, d0, e0;
            string a1, b1, c1, d1, e1;
            string a2, b2, c2, d2, e2;
            string a3, b3, c3, d3, e3;
            string f1, f2, f3, f4;

            f1 = GetPracInfo(date, stdformat, currentPage[0, date], out a0, out b0, out c0, out d0, out e0);
            f2 = GetPracInfo(date, stdformat, currentPage[1, date], out a1, out b1, out c1, out d1, out e1);
            f3 = GetPracInfo(date, stdformat, currentPage[2, date], out a2, out b2, out c2, out d2, out e2);
            f4 = GetPracInfo(date, stdformat, currentPage[3, date], out a3, out b3, out c3, out d3, out e3);

            string line = string.Format(RemoveLF(tableRowFormat),
                a0, b0, c0, d0, e0,
                a1, b1, c1, d1, e1,
                a2, b2, c2, d2, e2,
                a3, b3, c3, d3, e3);
            line = line.Replace("#col1#", f1);
            line = line.Replace("#col2#", f2);
            line = line.Replace("#col3#", f3);
            line = line.Replace("#col4#", f4);
            body += line;
        }
        dataLabelTable.EditValue = header + body + RemoveLF(tableFooterFormat);
    }
		    
    string GetPracInfo(Date data, string stdformat, object v, out string dzn, out string odGodz, out string doGodz, out string info, out string podpis) {
        string format = "";
        string s = "";
        if (v == null)				//Brak pracownika lub Niezatrudniony			
            format = stdformat;
        else if (v is bool)
            format = zwolnFormat;
        else if (v is DefinicjaNieobecnosci) {	//Nieobecność 
            s = ((DefinicjaNieobecnosci)v).Skrot;
            format = nieobecFormat;
        }
        else
            switch (((Dzien)v).Definicja.Typ) {
                case TypDnia.Pracy:
                    format = normalFormat; break;
                case TypDnia.Wolny:
                    format = wolnyFormat; break;
                case TypDnia.Świąteczny:
                    format = swietoFormat; break;
                default:
                    format = "?"; break;
            }

        if (v == null)
            dzn = odGodz = doGodz = info = podpis = string.Format(format, "");
        else {
            dzn = string.Format(format, data.Day);
            if (srpars.PokazPlanPracy && v is Dzien && ((Dzien)v).Czas != Time.Zero) {
                Dzien dzień = (Dzien)v;
                odGodz = string.Format(format.Replace("{0}", "{0:+}"), dzień.OdGodziny);
                doGodz = string.Format(format.Replace("{0}", "{0:+}"), Dzien.DoGodziny(dzień));
                info = string.Format(format, dzień.Czas);
                podpis = string.Format(format, "");
            }
            else {
                odGodz = doGodz = podpis = string.Format(format, "");
                info = string.Format(format, s);
            }
        }

        string clName = "";
        string clLbl = "BACKGROUND-COLOR: ";
        string[] attrs = format.Split(';');
        foreach (string attr in attrs)
            if (attr.Contains(clLbl)) {
                clName = attr.Replace(clLbl, "");
                break;
            }
        return clName;
    }
		    
    string PracTitle(Pracownik pracownik) {
        return pracownik==null ? "&nbsp;": pracownik.ImięNazwisko;
    }        

    static string RemoveLF(string value) {
        return value.Replace("\r\n", "");
    }
		    	
    static string tableHeaderFormat = @"
<table style=""FONT-SIZE: 5pt; FONT-FAMILY: Tahoma"" width=""100%"" cellpadding=""0"" 
cellspacing=""0"">
<tr>
<td colspan=""5"" width=""25%""                                 
style=""FONT-SIZE: 7pt; FONT-FAMILY: Tahoma; border-style: solid; border-width: 1px 2px 1px 1px; border-color: silver; font-weight: bolder;"" 
align=""center"">
{0}</td>
<td colspan=""5"" width=""25%""
style=""FONT-SIZE: 7pt; FONT-FAMILY: Tahoma; border-width: 1px 2px 1px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder; border-top-style: solid;"" 
align=""center"">
{1}</td>
<td colspan=""5"" width=""25%""
style=""FONT-SIZE: 7pt; FONT-FAMILY: Tahoma; border-width: 1px 2px 1px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder; border-top-style: solid;"" 
align=""center"">
{2}</td>
<td colspan=""5"" width=""25%""
style=""FONT-SIZE: 7pt; FONT-FAMILY: Tahoma; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder; border-top-style: solid;"" 
align=""center"">
{3}</td>
</tr>
<tr>
<td rowspan=""2"" 
style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder; border-left-style: solid;"" 
align=""center"">
dzień<br />miesiąca</td>
<td style=""border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" colspan=""2"">
godz. pracy</td>
<td align=""center"" 
style=""border-width: 1px; border-color: silver; border-right-style: solid; font-weight: bolder;"">ilość godzin</td>
<td rowspan=""2"" width=""10%""
style=""border-width: 1px 2px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"">podpis</td>
<td rowspan=""2"" 
style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"">
dzień miesiąca</td>
<td style=""border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" colspan=""2"">godz. pracy</td>
<td align=""center"" 
style=""border-width: 1px; border-color: silver; border-right-style: solid; font-weight: bolder;"">ilość godzin</td>
<td rowspan=""2"" width=""10%"" 
style=""border-width: 1px 2px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"">podpis</td>
<td rowspan=""2"" 
style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"">dzień miesiąca</td>
<td 
style=""border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" colspan=""2"">
godz. pracy</td>
<td align=""center"" 
style=""border-width: 1px; border-color: silver; border-right-style: solid; font-weight: bolder;"">ilość godzin</td>
<td rowspan=""2"" width=""10%""
style=""border-width: 1px 2px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"">podpis</td>
<td rowspan=""2"" 
style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"">
dzień miesiąca</td>
<td style=""border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" colspan=""2"">godz. pracy</td>
<td align=""center"" 
style=""border-width: 1px; border-color: silver; border-right-style: solid; font-weight: bolder;"">ilość godzin</td>
<td rowspan=""2"" width=""10%"" 
style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"">podpis</td>
</tr>
<tr>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">od</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">do</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">
lub rodzaj nieobec-<br />ności</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">od</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">do</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">
lub rodzaj nieobec-<br />ności</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">od</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">do</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">
lub rodzaj nieobec-<br />ności</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">od</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">do</td>
<td style=""border-width: 1px 1px 2px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; font-weight: bolder;"" 
align=""center"" width=""5%"">
lub rodzaj nieobec-<br />ności</td>
</tr>
";
		    		    	        
static string tableRowFormat = @"
<tr>
<td height=""26px"" align=""center"" style=""background-color: #col1#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid; border-left-style: solid;"">{0}</td>
<td align=""center"" style=""background-color: #col1#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{1}</td>
<td align=""center"" style=""background-color: #col1#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{2}</td>
<td align=""center"" style=""background-color: #col1#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{3}</td>
<td align=""center"" style=""background-color: #col1#; border-width: 1px 2px 1px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{4}</td>
<td align=""center"" style=""background-color: #col2#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{5}</td>
<td align=""center"" style=""background-color: #col2#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{6}</td>
<td align=""center"" style=""background-color: #col2#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{7}</td>
<td align=""center"" style=""background-color: #col2#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{8}</td>
<td align=""center"" style=""background-color: #col2#; border-width: 1px 2px 1px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{9}</td>
<td align=""center"" style=""background-color: #col3#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{10}</td>
<td align=""center"" style=""background-color: #col3#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{11}</td>
<td align=""center"" style=""background-color: #col3#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{12}</td>
<td align=""center"" style=""background-color: #col3#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{13}</td>
<td align=""center"" style=""background-color: #col3#; border-width: 1px 2px 1px 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{14}</td>
<td align=""center"" style=""background-color: #col4#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{15}</td>
<td align=""center"" style=""background-color: #col4#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{16}</td>
<td align=""center"" style=""background-color: #col4#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{17}</td>
<td align=""center"" style=""background-color: #col4#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{18}</td>
<td align=""center"" style=""background-color: #col4#; border-width: 1px; border-color: silver; border-right-style: solid; border-bottom-style: solid;"">{19}</td>
</tr>
";

static string tableFooterFormat = @"</table>";

static void Msg(object obj) {
}
		    
</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ListaObecności" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" 
                TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad" 
                BottomMargin="-1" LeftMargin="-1" RightMargin="-1" TopMargin="-1"></ea:datacontext>
			<ea:datarepeater id="DataRepeater1" runat="server" onbeforerow="DataRepeater1_BeforeRow" Width="100%">
			    <ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
				<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
				<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title='Lista obecności</STRONG>|Wydział: <STRONG>%WYDZIAL%</STRONG>|Za miesiąc: <STRONG>%MIESIĄC%</STRONG>|Opiekun listy obecności: ................................................|str. <STRONG>%NR%</STRONG>' runat="server"></cc1:reportheader>			    
				<ea:DataLabel ID="dataLabelTable" runat="server" Bold="False"></ea:DataLabel>
				<cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
				<ea:SectionMarker id="SectionMarker2" runat="server" SectionType="Footer"></ea:SectionMarker>
            </ea:datarepeater>
		</form>
	</body>
</HTML>
